#!/bin/sh

TP_YESNO_RESULT_YES="DTAS[TUI]@{YES}"
TP_YESNO_RESULT_NO="DTAS[TUI]@{NO}"
TP_YESNO_RESULT_NULL="DTAS[TUI]@{NULL}"
TP_YESNO_RESULT_SELECT=""

TP_YESNO_RESULT_OK="DTAS[TUI]@{OK}"
TP_YESNO_RESULT_CANCEL="DTAS[TUI]@{CANCEL}"
TP_YESNO_RESULT_ERROR="DTAS[TUI]@{ERROR}"
TP_YESNO_RESULT_CODE=""

TP_YESNO_RESULT_MSG=""

tp_yesno() {
	local title="${1}"
	local message="${2}"
	local label_yes="${3:-Yes}"
	local label_no="${4:-No}"
	
	dialog \
	--backtitle	"${CONS_BACK_TITLE}" \
	--title		"${title}" \
	--yes-label	"${label_yes}" \
	--no-label	"${label_no}" \
	--yesno		"${message}" \
				"${CONS_BOX_HEIGHT}" \
				"${CONS_BOX_WIDTH}"

    local ret="${?}"
	case "${ret}" in
		0)
			TP_YESNO_RESULT_CODE="${TP_YESNO_RESULT_OK}"
            TP_YESNO_RESULT_SELECT="${TP_YESNO_RESULT_YES}"
            TP_YESNO_RESULT_MSG=""
			;;
            
		1|255)
            TP_YESNO_RESULT_CODE="${TP_YESNO_RESULT_OK}"
            TP_YESNO_RESULT_SELECT="${TP_YESNO_RESULT_NO}"
			TP_YESNO_RESULT_MSG=""
			;;
		*)
            TP_YESNO_RESULT_CODE="${TP_YESNO_RESULT_ERROR}"
            TP_YESNO_RESULT_SELECT="${TP_YESNO_RESULT_NULL}"
			TP_YESNO_RESULT_MSG=""
            
			TP_YESNO_RESULT_CODE="${TP_YESNO_RESULT_ERROR}"
			return;;
	esac
}

